
<?php $__env->startSection('title'); ?>
    <?php echo e(__("message.Login")); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta-data'); ?>
<meta property="og:type" content="website"/>
<meta property="og:url" content="<?php echo e(route('user-login')); ?>"/>
<meta property="og:title" content="<?php echo e(__('message.site_name')); ?>"/>
<meta property="og:image" content="<?php echo e(asset('public/img/').'/'.$setting->logo); ?>"/>
<meta property="og:image:width" content="250px"/>
<meta property="og:image:height" content="250px"/>
<meta property="og:site_name" content="<?php echo e(__('message.site_name')); ?>"/>
<meta property="og:description" content="<?php echo e(__('message.meta_description')); ?>"/>
<meta property="og:keyword" content="<?php echo e(__('message.meta_keyword')); ?>"/>
<link rel="shortcut icon" href="<?php echo e(asset('public/img/').'/'.$setting->favicon); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<section class="page-title-two">
            <div class="title-box centred bg-color-2">
                <div class="pattern-layer">
                    <div class="pattern-1" style="background-image: url(assets/images/shape/shape-70.png);"></div>
                    <div class="pattern-2" style="background-image: url(assets/images/shape/shape-71.png);"></div>
                </div>
                <div class="auto-container">
                    <div class="title">
                        <h1><?php echo e(__("message.Login")); ?></h1>
                    </div>
                </div>
            </div>
            <div class="lower-content">
                <div class="auto-container">
                    <ul class="bread-crumb clearfix">
                        <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__("message.Home")); ?></a></li>
                        <li><?php echo e(__("message.Login")); ?></li>
                    </ul>
                </div>
            </div>
        </section>
        <section class="registration-section bg-color-3">
            <div class="pattern">
                <div class="pattern-1" style="background-image: url(assets/images/shape/shape-85.png);"></div>
                <div class="pattern-2" style="background-image: url(assets/images/shape/shape-86.png);"></div>
            </div>
            <div class="auto-container">
                <div class="inner-box">
                    <div class="content-box">
                        <div class="title-box">
                            <h3><?php echo e(__("message.User Login")); ?></h3>
                            <a href="<?php echo e(route('user-register')); ?>"><?php echo e(__("message.Not a User")); ?>?</a>
                        </div>
                        <div class="inner">
                             <?php if(Session::has('message')): ?>
                                 <div class="col-sm-12">
                                    <div class="alert  <?php echo e(Session::get('alert-class', 'alert-info')); ?> alert-dismissible fade show" role="alert"><?php echo e(Session::get('message')); ?>

                                       <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                       <span aria-hidden="true">&times;</span></button>
                                    </div>
                                 </div>
                                 <?php endif; ?>
                            <form action="<?php echo e(route('post-user-login')); ?>" method="post" class="registration-form">
                                 <?php echo e(csrf_field()); ?>

                                <div class="row clearfix">
                                   
                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <label><?php echo e(__("message.email")); ?></label>
                                        <input type="email" name="email" placeholder="<?php echo e(__('message.Enter Email')); ?>" required="" value="<?php echo e(isset($_COOKIE['email'])?$_COOKIE['email']:''); ?>">
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <label><?php echo e(__("message.password")); ?></label>
                                        <input type="password" name="password" placeholder="<?php echo e(__('message.Enter Password')); ?>" value="<?php echo e(isset($_COOKIE['password'])?$_COOKIE['password']:''); ?>" required="">
                                    </div>
                                    
                                    <div class="col-lg-8 col-md-12 col-sm-12 form-group">
                                        <div class="custom-check-box">
                                            <div class="custom-controls-stacked">
                                                <label class="custom-control material-checkbox">
                                                    <input type="checkbox" class="material-control-input" name="rem_me" id="rem_me" value="1">
                                                    <span class="material-control-indicator"></span>
                                                    <span class="description"><?php echo e(__("message.Remember")); ?></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-12 col-sm-12 form-group">
                                        <a href="<?php echo e(route('forgotpassword')); ?>" class="forgot_line"><?php echo e(__("message.Forgotpassword")); ?></a>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group message-btn">
                                        <button type="submit" class="theme-btn-one"><?php echo e(__("message.Login")); ?><i class="icon-Arrow-Right"></i></button>
                                    </div>
                                </div>
                            </form>
                            <div class="text"><span><?php echo e(__("message.or")); ?></span></div>
                           <!-- <ul class="social-links clearfix">
                                <li><a href="#"><?php echo e(__("message.Login with Facebook")); ?></a></li>
                                <li><a href="#"><?php echo e(__("message.Login with Google Plus")); ?></a></li>
                            </ul>-->
                            <div class="login-now"><p><?php echo e(__("message.don't have an account")); ?>? <a href="<?php echo e(route('user-register')); ?>"><?php echo e(__("message.Register Now")); ?></a></p></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
 
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/freakd1c/public_html/demo/laboratory/resources/views/front/login.blade.php ENDPATH**/ ?>