<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\ApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get("add_all_reviews",[ApiController::class,"add_all_reviews"]);

Route::post("login",[ApiController::class,"post_login"]);
Route::post("register",[ApiController::class,"post_register"]);
Route::any("savetoken",[ApiController::class,"post_savetoken"]);
Route::any("getcategory",[ApiController::class,"get_category"]);
Route::any("serach_category",[ApiController::class,"serach_category"]);
Route::any("category_detail",[ApiController::class,"get_category_detail"]);
Route::any("forgotpassword",[ApiController::class,"forgotpassword"]);
Route::any("package_detail",[ApiController::class,"package_detail"]);
Route::any("profile_detail",[ApiController::class,"profile_detail"]);
Route::any("parameter_detail",[ApiController::class,"parameter_detail"]);
Route::any("get_popular_package_list",[ApiController::class,"get_popular_package_list"]);
Route::any("save_member",[ApiController::class,"save_member"]);
Route::get("delete_member",[ApiController::class,"delete_member"]);
Route::get("get_member_list",[ApiController::class,"get_member_list"]);

Route::any("saveaddress",[ApiController::class,"save_address"]);
Route::get("getaddress",[ApiController::class,"getaddress"]);
Route::get("delete_address",[ApiController::class,"delete_address"]);
Route::any("booknow",[ApiController::class,"booknow"]);
Route::any("edit_profile",[ApiController::class,"edit_profile"]);
Route::any("add_review",[ApiController::class,"add_review"]);
Route::any("book_filter",[ApiController::class,"book_filter"]);
Route::any("add_feedback",[ApiController::class,"add_feedback"]);
Route::get("update_cart",[ApiController::class,"update_cart"]);
Route::get("get_cart",[ApiController::class,"get_cart"]);
Route::get("book_detail",[ApiController::class,"book_detail"]);
Route::get("get_city",[ApiController::class,"get_city"]);

Route::any("about",[ApiController::class,"about"]);
Route::any("privecy",[ApiController::class,"privecy"]);

Route::any("delete_user",[ApiController::class,"delete_user"]);

//address add.edit.delete.list
//book detail
//check out
//edit profile
//add review