@extends('front.layout')
@section('title')
{{isset($subcategory->name)?$subcategory->name:''}} {{__("message.Detail")}} 
@stop
@section('meta-data')
<meta property="og:type" content="website"/>
<meta property="og:url" content="{{route('service')}}"/>
<meta property="og:title" content="{{$subcategory->name}}"/>
<meta property="og:image" content="{{asset('public/img/').'/'.$setting->logo}}"/>
<meta property="og:image:width" content="250px"/>
<meta property="og:image:height" content="250px"/>
<meta property="og:site_name" content="{{__('message.site_name')}}"/>
<meta property="og:description" content="{{__('message.meta_description')}}"/>
<meta property="og:keyword" content="{{__('message.meta_keyword')}}"/>
<link rel="shortcut icon" href="{{asset('public/img/').'/'.$setting->favicon}}">
<meta name="viewport" content="width=device-width, initial-scale=1">
@stop
@section('content')
<?php $res_curr = explode("-",$setting->currency);?>
<section class="page-title-two">
   <div class="title-box centred bg-color-2">
      <div class="pattern-layer">
          <?php 
                          $sharp70 = asset('public/front/Docpro/assets/images/shape/shape-70.png');
                          $sharp71 = asset('public/front/Docpro/assets/images/shape/shape-71.png');
                          $sharp49 = asset('public/front/Docpro/assets/images/shape/shape-49.png');
                          $sharp50 = asset('public/front/Docpro/assets/images/shape/shape-50.png');
                          $sharp54 = asset('public/front/Docpro/assets/images/shape/shape-54.png');
                    ?>
                    <div class="pattern-1" style="background-image: url('{{$sharp70}}');"></div>
                    <div class="pattern-2" style="background-image: url('{{$sharp71}}');"></div>
      </div>
      <div class="auto-container">
         <div class="title">
            <h1>{{isset($subcategory->name)?$subcategory->name:''}} {{__("message.Detail")}} </h1>
         </div>
      </div>
   </div>
   <div class="lower-content">
      <div class="auto-container">
         <ul class="bread-crumb clearfix">
            <li><a href="{{route('home')}}">Home</a></li>
            <li>{{isset($subcategory->name)?$subcategory->name:''}} {{__("message.Detail")}} </li>
         </ul>
      </div>
   </div>
</section>

<section class="pricing-section bg-color-3 sec-pad" style="padding: 40px 0px 120px 0px;">
   <div class="auto-container">
       
      <div class="tabs-box">
         <?php 
            $sharp75 = asset('public/front/Docpro/assets/images/shape/shape-75.png');
            $sharp76 = asset('public/front/Docpro/assets/images/shape/shape-76.png');
            $sharp77 = asset('public/front/Docpro/assets/images/shape/shape-77.png');
            ?>
         <div class="tabs-content">
            <div class="tab active-tab" id="tab-1">
                @if(count($perameter) > 0 )
                <div class="sec-title " style="margin-bottom: 20px;">
                    <!--<p>Process</p>-->
                    <h2>Perameter</h2>
                </div>
                <div class="row clearfix">
                    @foreach($perameter as $pl)
                        <?php $discount = 100 * ($pl['mrp'] - $pl['price']) / $pl['mrp']; ?>
                            <div class="col-lg-4 col-md-4 col-sm-4 pricing-block">
                               <div class="pricing-block-one">
                                  <div class="pricing-table">
    
                                     <div class="pattern">
                                         <span class="discount" >{{$res_curr[1]}}{{round($discount)}} %</span>
                                        <div class="pattern-1" style="background-image: url('{{$sharp75}}');"></div>
                                        <div class="pattern-2" style="background-image: url('{{$sharp76}}');"></div>
                                        <div class="pattern-3" style="background-image: url('{{$sharp77}}');"></div>
                                     </div>
                                     <div class="table-header" style="margin-bottom: 10px; padding-bottom: 10px;">
                                        <h2> {{ \Illuminate\Support\Str::limit($pl['name'],11, $end='..') }}</h2>
                                            
                                        <h3><span style="text-decoration: line-through;">{{$res_curr[1]}}{{number_format($pl['mrp'],2,'.','')}}</span> / {{$res_curr[1]}}{{number_format($pl['price'],2,'.','')}} </h3>
                                        <p><span>{{__("message.Includes")}}  :  </span> {{$pl['no_of_parameter']}} {{__("message.Parameters")}} </p>
                                     </div>
                                     <div class="table-content">
                                        <ul class="list clearfix" style="height: 0px;">
                                           <?php $i=0;?>
                                           @foreach($pl['parameter_list'] as $a)
                                                @if($i < 4)
                                                    <li><span class="mr10">{{ \Illuminate\Support\Str::limit($a,34, $end='..') }}</span></li>
                                                    <?php $i++; ?>
                                                @endif
                                           @endforeach
                                        </ul>
                                     </div>
                                     <div class="table-footer">
                                        <div class="link">
                                           @if($pl['type']==1)
                                              <a href="{{ route('package-detail', ['id' => $pl['id'] ]) }}"><i class="icon-Arrow-Right"></i></a>
                                           @elseif($pl['type']==3)
                                              <a href="{{ route('profile-detail', ['id' => $pl['id'] ]) }}"><i class="icon-Arrow-Right"></i></a>
                                           @elseif($pl['type']==2)
                                              <a href="{{ route('parameter-detail', ['id' => $pl['id'] ]) }}"><i class="icon-Arrow-Right"></i></a>
                                           @endif
                                        </div>
                                        <div class="btn-box">
                                           @if($pl['type']==1)
                                              <a href="{{ route('package-detail', ['id' => $pl['id'] ]) }}" class="theme-btn-one">{{__("message.Know More")}} <i class="icon-Arrow-Right"></i></a>
                                           @elseif($pl['type']==3)
                                              <a href="{{ route('profile-detail', ['id' => $pl['id'] ]) }}" class="theme-btn-one">{{__("message.Know More")}} <i class="icon-Arrow-Right"></i></a>
                                           @elseif($pl['type']==2)
                                              <a href="{{ route('parameter-detail', ['id' => $pl['id'] ]) }}" class="theme-btn-one">{{__("message.Know More")}} <i class="icon-Arrow-Right"></i></a>
                                           @endif
                                        </div>
                                     </div>
                                  </div>
                               </div>
                            </div>
                    @endforeach
                </div> 
                @endif
                @if(count($profile) > 0 ) 
                <div class="sec-title" style=" margin-top: 40px; margin-bottom: 20px;">
                    <!--<p>Process</p>-->
                    <h2>Profile</h2>
                </div>
                <div class="row clearfix" >
                    @foreach($profile as $pl)
                        <?php $discount = 100 * ($pl['mrp'] - $pl['price']) / $pl['mrp']; ?>
                            <div class="col-lg-4 col-md-4 col-sm-4 pricing-block">
                               <div class="pricing-block-one">
                                  <div class="pricing-table">
    
                                     <div class="pattern">
                                         <span class="discount" >{{$res_curr[1]}}{{round($discount)}} %</span>
                                        <div class="pattern-1" style="background-image: url('{{$sharp75}}');"></div>
                                        <div class="pattern-2" style="background-image: url('{{$sharp76}}');"></div>
                                        <div class="pattern-3" style="background-image: url('{{$sharp77}}');"></div>
                                     </div>
                                     <div class="table-header">
                                        <h2> {{ \Illuminate\Support\Str::limit($pl['name'],11, $end='..') }}</h2>
                                            
                                        <h3><span style="text-decoration: line-through;">{{$res_curr[1]}}{{number_format($pl['mrp'],2,'.','')}}</span> / {{$res_curr[1]}}{{number_format($pl['price'],2,'.','')}} </h3>
                                        <p><span>{{__("message.Includes")}}  :  </span> {{$pl['no_of_parameter']}} {{__("message.Parameters")}} </p>
                                     </div>
                                     <div class="table-content">
                                        <ul class="list clearfix" style="height: 150px;">
                                           <?php $i=0;?>
                                           @foreach($pl['parameter_list'] as $a)
                                                @if($i < 4)
                                                    <li><span class="mr10">{{$a}}</span></li>
                                                    <?php $i++; ?>
                                                @endif
                                           @endforeach
                                        </ul>
                                     </div>
                                     <div class="table-footer">
                                        <div class="link">
                                           @if($pl['type']==1)
                                              <a href="{{ route('package-detail', ['id' => $pl['id'] ]) }}"><i class="icon-Arrow-Right"></i></a>
                                           @elseif($pl['type']==3)
                                              <a href="{{ route('profile-detail', ['id' => $pl['id'] ]) }}"><i class="icon-Arrow-Right"></i></a>
                                           @elseif($pl['type']==2)
                                              <a href="{{ route('parameter-detail', ['id' => $pl['id'] ]) }}"><i class="icon-Arrow-Right"></i></a>
                                           @endif
                                        </div>
                                        <div class="btn-box">
                                           @if($pl['type']==1)
                                              <a href="{{ route('package-detail', ['id' => $pl['id'] ]) }}" class="theme-btn-one">{{__("message.Know More")}} <i class="icon-Arrow-Right"></i></a>
                                           @elseif($pl['type']==3)
                                              <a href="{{ route('profile-detail', ['id' => $pl['id'] ]) }}" class="theme-btn-one">{{__("message.Know More")}} <i class="icon-Arrow-Right"></i></a>
                                           @elseif($pl['type']==2)
                                              <a href="{{ route('parameter-detail', ['id' => $pl['id'] ]) }}" class="theme-btn-one">{{__("message.Know More")}} <i class="icon-Arrow-Right"></i></a>
                                           @endif
                                        </div>
                                     </div>
                                  </div>
                               </div>
                            </div>
                    @endforeach 
                </div>
                @endif
                @if(count($package) > 0 )
                <div class="sec-title" style=" margin-top: 40px; margin-bottom: 20px;">
                    <!--<p>Process</p>-->
                    <h2>Packages</h2>
                </div>
                <div class="row clearfix" >
                    @foreach($package as $pl)
                        <?php $discount = 100 * ($pl['mrp'] - $pl['price']) / $pl['mrp']; ?>
                            <div class="col-lg-4 col-md-4 col-sm-4 pricing-block">
                               <div class="pricing-block-one">
                                  <div class="pricing-table">
    
                                     <div class="pattern">
                                         <span class="discount" >{{$res_curr[1]}}{{round($discount)}} %</span>
                                        <div class="pattern-1" style="background-image: url('{{$sharp75}}');"></div>
                                        <div class="pattern-2" style="background-image: url('{{$sharp76}}');"></div>
                                        <div class="pattern-3" style="background-image: url('{{$sharp77}}');"></div>
                                     </div>
                                     <div class="table-header">
                                        <h2> {{ \Illuminate\Support\Str::limit($pl['name'],11, $end='..') }}</h2>
                                            
                                        <h3><span style="text-decoration: line-through;">{{$res_curr[1]}}{{number_format($pl['mrp'],2,'.','')}}</span> / {{$res_curr[1]}}{{number_format($pl['price'],2,'.','')}} </h3>
                                        <p><span>{{__("message.Includes")}}  :  </span> {{$pl['no_of_parameter']}} {{__("message.Parameters")}} </p>
                                     </div>
                                     <div class="table-content">
                                        <ul class="list clearfix" style="height: 150px;">
                                           <?php $i=0;?>
                                           @foreach($pl['parameter_list'] as $a)
                                                @if($i < 4)
                                                    <li><span class="mr10">{{$a}}</span></li>
                                                    <?php $i++; ?>
                                                @endif
                                           @endforeach
                                        </ul>
                                     </div>
                                     <div class="table-footer">
                                        <div class="link">
                                           @if($pl['type']==1)
                                              <a href="{{ route('package-detail', ['id' => $pl['id'] ]) }}"><i class="icon-Arrow-Right"></i></a>
                                           @elseif($pl['type']==3)
                                              <a href="{{ route('profile-detail', ['id' => $pl['id'] ]) }}"><i class="icon-Arrow-Right"></i></a>
                                           @elseif($pl['type']==2)
                                              <a href="{{ route('parameter-detail', ['id' => $pl['id'] ]) }}"><i class="icon-Arrow-Right"></i></a>
                                           @endif
                                        </div>
                                        <div class="btn-box">
                                           @if($pl['type']==1)
                                              <a href="{{ route('package-detail', ['id' => $pl['id'] ]) }}" class="theme-btn-one">{{__("message.Know More")}} <i class="icon-Arrow-Right"></i></a>
                                           @elseif($pl['type']==3)
                                              <a href="{{ route('profile-detail', ['id' => $pl['id'] ]) }}" class="theme-btn-one">{{__("message.Know More")}} <i class="icon-Arrow-Right"></i></a>
                                           @elseif($pl['type']==2)
                                              <a href="{{ route('parameter-detail', ['id' => $pl['id'] ]) }}" class="theme-btn-one">{{__("message.Know More")}} <i class="icon-Arrow-Right"></i></a>
                                           @endif
                                        </div>
                                     </div>
                                  </div>
                               </div>
                            </div>
                    @endforeach  
                </div>
                @endif
               <!--</div>-->
            </div>
         </div>
      </div>
   </div>
</section>


<section class="sidebar-page-container" style="padding: 0px;">
   <div class="auto-container">
      <div class="row clearfix">
         <div class="col-lg-12 col-md-12 col-sm-12 content-side">
            <div class="blog-details-content">
               <div class="news-block-one">
                  <div class="inner-box">
                     <div class="lower-content">
                        <h3>{{isset($subcategory->name)?$subcategory->name:''}} {{__('message.Tests')}}</h3>
                        <p><?= html_entity_decode($subcategory->description)?></p>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>


@stop
@section('footer')
<script>
    <?php if($setting->is_rtl==1){ ?>
   $('#packagelist').owlCarousel({
              loop:true,
              margin:10,
              rtl:true,
              autoplay:true,
              responsive:{
                0:{
                  items:1
                },
                600:{
                  items:3
                },
                1000:{
                  items:3
                }
              }
            })
<?php }else{?>
   $('#packagelist').owlCarousel({
              loop:true,
              margin:10,
              autoplay:true,
              responsive:{
                0:{
                  items:1
                },
                600:{
                  items:3
                },
                1000:{
                  items:3
                }
              }
            })
<?php }?>
</script>
@stop