@extends('admin.layout.index')
@section('title')
{{__("message.Notification")}}
@stop
@section('content')
<div class="page-header">
	<h3 class="page-title">{{__("message.Notification")}} </h3>
	<nav aria-label="breadcrumb">	      		
       <ol class="breadcrumb">
         <li class="breadcrumb-item"><a href="{{route('admin-dashboard')}}">{{__("message.Home")}}</a></li>
         <li class="breadcrumb-item active">{{__("message.Notification")}}</li>
       </ol>
     </nav>	      	
</div>
<div class="row">
	<div class="col-lg-12 grid-margin stretch-card">
       <div class="card">                	
         <div class="card-body">
         	 @if(Session::has('message'))
            <div class="col-sm-12">
               <div class="alert  {{ Session::get('alert-class', 'alert-info') }} alert-dismissible fade show" role="alert">{{ Session::get('message') }}
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                  </button>
               </div>
            </div>
            @endif
            <a href="{{url('save_notification')}}"  class="btn btn-success" style="margin-bottom: 10px">{{__("message.Add Notification")}}</a>
            <div class="table-responsive">
                 <table id="notification_table" class="table table-bordered text-nowrap dataTable no-footer">
                   	<thead>
                     <tr>
                       	<th>{{__("message.ID")}}</th>
                         <th>{{__("message.Message")}}</th>
                     </tr>
                   	</thead>
                   	<tbody>                        
                   	</tbody>
                   	
                 </table>
              </div>
         </div>
       </div>
     </div>
</div>

<script>
    
$(document).ready(function () {
   
    $('#notification_table').DataTable({
        processing: true,
        serverSide: true,
       
        ajax: $("#url_path").val()+'/notification_table',
        columns: [
            {data: 'id'    , name: 'id'},            
            {data: 'message' , name:'message'}
        ]
    });
});
</script>
@endsection